
import React from 'react';
import { connect } from 'react-redux'
import { View, Text, TouchableOpacity, StyleSheet } from 'react-native';
import { URL_API, fetchUserTodosStarted, deleteUserTodos, fetchUserTodos } from '../context/Actions';
import TodosList from './TodosList';

const UserListItem = (props) => {
    const { todos, user_labels, } = props;
    const { userid } = todos;
    const { item } = props;
    const handleOnClick = (id) => {
        if (userid !== id) {
            props.fetchUserTodosStarted (id);//dispatch(fetchUserTodosStarted(id));
            const url = `${URL_API}/posts?userId=${id}`;
            const request = {};
            props.fetchUserTodos(url, request);
        } else {
            props.deleteUserTodos();//dispatch(deleteUserTodos());
        }
    };
    if (userid !== item.id) {
        return (
            <View style={styles.item}>
                <TouchableOpacity onPress={() => handleOnClick(item.id)}>
                    <Text>{user_labels.id} : {item.id} </Text>
                    <Text>{user_labels.name} : {item.name} </Text>
                    <Text>{user_labels.username}:  {item.username} </Text>
                    <Text>{user_labels.email} : {item.email} </Text>
                </TouchableOpacity>
            </View >
        );
    } else {
        return (
            <View style={styles.item}>
                <View style={styles.item}>
                    <TouchableOpacity onPress={() => handleOnClick(item.id)}>
                        <Text>{user_labels.id} : {item.id} </Text>
                        <Text>{user_labels.name} : {item.name} </Text>
                        <Text>{user_labels.username}:  {item.username} </Text>
                        <Text>{user_labels.email} : {item.email} </Text>
                    </TouchableOpacity>
                </View >
                <TodosList />
            </View >
        );
    }
}
const styles = StyleSheet.create({
    button: {
        alignItems: 'center',
        padding: 5
    },
    item: {
        borderTopWidth: 2,
        borderBottomWidth: 2,
        borderColor: "black"
    },
});
const mapStateToProps = (state) => {
    return {
        users: state.users,
        todos: state.todos,
        user_labels: state.user_labels,
    };
}
const mapDispatchToProps = (dispatch) => {
    return {
        fetchUserTodosStarted: (id) => dispatch(fetchUserTodosStarted(id)),
        fetchUserTodos: (url, request) => fetchUserTodos(url, request, dispatch),
        deleteUserTodos: () => dispatch(deleteUserTodos()),
       
    }
}
export default connect(mapStateToProps, mapDispatchToProps)(UserListItem)
